<?php

namespace Drupal\Tests\content_translation_access\Kernel;

use Drupal\Core\Language\Language;
use Drupal\node\Entity\Node;

/**
 * Tests AccessControlHandler.
 *
 * @coversDefaultClass \Drupal\content_translation_access\AccessControlHandler
 *
 * @group content_translation_access
 */
class AccessControlHandlerTest extends ContentTranslationAccessKernelTestBase {

  /**
   * Modules to enable.
   *
   * @var array<string>
   */
  protected static $modules = [
    'system',
    'user',
    'entity_test',
    'language',
    'content_translation',
    'content_translation_test',
    'content_translation_access',
    'node',
  ];

  /**
   * Test AccessControlHandler::access.
   *
   * @covers ::access
   */
  public function testAccess() {

    // Create the article node type with revisions disabled.
    $user = $this->createUser(
          [
            'administer nodes',
            'cta translate node page',
            'cta delete translation node page',
          ]
      );

    // Check that user was created successfully.
    $this->assertNotFalse($user, 'User should be created successfully.');
    $this->assertInstanceOf('\Drupal\user\Entity\User', $user);

    $node_en = Node::create(
          [
            'title' => $this->randomMachineName(),
            'uid' => $user->id(),
            'type' => 'page',
          ]
      );
    $node_en->save();

    $handler = $this->accessHandler;
    /** @var \Drupal\Core\Access\AccessResultInterface $access */
    $access = $handler->access($node_en, 'update', $user);
    $this->assertEquals(TRUE, $access->isAllowed());

    $access = $handler->access($node_en, 'delete', $user);
    $this->assertEquals(TRUE, $access->isAllowed());

    $access = $handler->access($node_en, 'view', $user);
    $this->assertEquals(TRUE, $access->isNeutral());
  }

  /**
   * Test AccessControlHandler::createAccess.
   *
   * @covers ::createAccess
   */
  public function testCreateAccess() {

    // Create the article node type with revisions disabled.
    $user = $this->createUser([
      'cta create translation node page',
    ]);

    // Check that user was created successfully.
    $this->assertNotFalse($user, 'User should be created successfully.');
    $this->assertInstanceOf('\Drupal\user\Entity\User', $user);

    $en = new Language(['name' => 'en', 'id' => 'en']);
    $handler = $this->accessHandler;
    /** @var \Drupal\Core\Access\AccessResultInterface $access */
    $access = $handler->createAccess('node', 'page', $en, $user);
    $this->assertEquals(TRUE, $access->isAllowed());
  }

  /**
   * Test AccessControlHandler::createAnyAccess.
   *
   * @covers ::createAnyAccess
   */
  public function testCreateAnyAccess() {

    // Create the article node type with revisions disabled.
    $user = $this->createUser([
      'administer nodes',
      'cta create translation node page',
    ]);

    // Check that user was created successfully.
    $this->assertNotFalse($user, 'User should be created successfully.');
    $this->assertInstanceOf('\Drupal\user\Entity\User', $user);

    $handler = $this->accessHandler;
    /** @var \Drupal\Core\Access\AccessResultInterface $access */
    $access = $handler->createAnyAccess('node', 'page', $user);
    $this->assertEquals(TRUE, $access->isAllowed());
  }

}
