<?php

namespace Drupal\Tests\content_translation_access\Kernel;

use Drupal\content_translation\ContentTranslationManagerInterface;
use Drupal\content_translation_access\AccessControlHandler;
use Drupal\content_translation_access\Plugin\LanguageProviderInterface;
use Drupal\Core\Language\Language;
use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\node\Traits\ContentTypeCreationTrait;
use Drupal\Tests\user\Traits\UserCreationTrait;
use Prophecy\PhpUnit\ProphecyTrait;

/**
 * Base controller.
 *
 * @group content_translation_access
 */
class ContentTranslationAccessKernelTestBase extends KernelTestBase {

  use ProphecyTrait;
  use ContentTypeCreationTrait;
  use UserCreationTrait;

  /**
   * Modules to enable.
   *
   * @var array<string>
   */
  protected static $modules = [
    'system',
    'user',
    'entity_test',
    'language',
    'content_translation',
    'content_translation_test',
    'content_translation_access',
    'node',
    'field',
    'text',
    'filter',
  ];

  /**
   * The mocked access handler.
   *
   * @var \Drupal\content_translation_access\AccessControlHandler
   */
  protected $accessHandler;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Install the necessary schemas.
    $this->installEntitySchema('node');
    $this->installEntitySchema('user');
    $this->installSchema('node', ['node_access']);
    $this->installConfig(['filter', 'field', 'text', 'node', 'content_translation', 'language']);

    // Create the page content type.
    $this->createContentType(['type' => 'page', 'name' => 'Page']);

    // Enable content translation for the page content type.
    $this->container->get('content_translation.manager')
      ->setEnabled('node', 'page', TRUE);

    // Create mocks using Prophecy properly.
    $language_manager = $this->prophesize(LanguageManagerInterface::class);
    $language_manager->getLanguages()->willReturn(
      [
        new Language(['name' => 'de', 'id' => 'de']),
        new Language(['name' => 'en', 'id' => 'en']),
      ]
    );

    $content_translation_handler = $this->prophesize(ContentTranslationManagerInterface::class);
    $content_translation_handler->isEnabled("node", "page")
      ->willReturn(TRUE);

    $language_provider = $this->prophesize(LanguageProviderInterface::class);
    $language_provider->getLanguages()
      ->willReturn([new Language(['name' => 'en', 'id' => 'en'])]);

    // Get the revealed mock objects.
    /** @var \Drupal\Core\Language\LanguageManagerInterface $language_manager_mock */
    $language_manager_mock = $language_manager->reveal();
    /** @var \Drupal\content_translation_access\Plugin\LanguageProviderInterface $language_provider_mock */
    $language_provider_mock = $language_provider->reveal();
    /** @var \Drupal\content_translation\ContentTranslationManagerInterface $content_translation_handler_mock */
    $content_translation_handler_mock = $content_translation_handler->reveal();

    $this->accessHandler = new AccessControlHandler($language_manager_mock, $language_provider_mock, $content_translation_handler_mock);

  }

}
