<?php

namespace Drupal\Tests\content_translation_access\Kernel;

use Drupal\content_translation_access\Permissions;
use Drupal\KernelTests\KernelTestBase;
use Drupal\Tests\node\Traits\ContentTypeCreationTrait;
use Drupal\Tests\user\Traits\UserCreationTrait;

/**
 * Tests Permissions.
 *
 * @coversDefaultClass \Drupal\content_translation_access\Permissions
 *
 * @group content_translation_access
 */
class PermissionsTest extends KernelTestBase {

  use ContentTypeCreationTrait;
  use UserCreationTrait;

  /**
   * Modules to enable.
   *
   * @var array<string>
   */
  protected static $modules = [
    'system',
    'user',
    'node',
    'field',
    'text',
    'filter',
    'language',
    'content_translation',
    'content_translation_access',
  ];

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    // Install the necessary schemas.
    $this->installEntitySchema('node');
    $this->installEntitySchema('user');
    $this->installSchema('node', ['node_access']);
    $this->installConfig(['filter', 'field', 'text', 'node', 'content_translation', 'language']);

    // Create the page content type.
    $this->createContentType(['type' => 'page', 'name' => 'Page']);

    // Enable content translation for the page content type.
    $this->container->get('content_translation.manager')
      ->setEnabled('node', 'page', TRUE);
  }

  /**
   * Test Permissions::hasPermission.
   *
   * @covers ::hasPermission
   */
  public function testHasPermission() {

    // Create the article node type with revisions disabled.
    $user = $this->createUser(['administer nodes', 'cta translate node page']);
    $this->assertNotFalse($user, 'User should be created successfully.');
    $this->assertInstanceOf('\Drupal\user\Entity\User', $user);

    $has_permission = Permissions::hasPermission('update', 'node', 'page', $user);
    $this->assertEquals(TRUE, $has_permission);

  }

}
