# Content View Access

## Overview

The Content View Access module provides a flexible way to control access to 
content based on its bundle (e.g., content type for nodes, vocabulary for 
taxonomy terms) and user role. You can configure rules to deny access, 
redirect users, or show a blank page for specific bundles and roles.

## Features

* **Role-based access control:** Define access rules for each user role.
* **Bundle-specific rules:** Apply rules to individual content types and
  vocabularies.
* **Multiple actions:**
  * Access Denied (403)
  * Not Found (404)
  * Front Page
  * Blank Page
* **Easy configuration:** A simple user interface to manage access rules.

## Installation

1. Copy the `content_view_access` directory to your Drupal `modules` directory.
2. Enable the module from the "Extend" page (`/admin/modules`).

## Configuration

1. Go to **Configuration > People > Content View Access**  
   (`/admin/config/people/content-view-access`).
2. To access this page, users will need the
   **Administer Content View Access** permission.
3. For each content type and vocabulary, you can set an action for each role.
4. Save the configuration.
