# Context: Menu Parent Active Trail

This module provides a **condition plugin for the [Context](https://www.drupal.org/project/context) module**.  
It evaluates **TRUE** whenever a selected **parent menu item** is present in the menu’s **active trail**.  
In other words, if the user navigates to any page that belongs to that parent item’s branch—children or even deeper levels—this condition will be met, **even if the URL path does not share the parent’s prefix**.

## Requirements
- Drupal 10 or 11
- [Context](https://www.drupal.org/project/context) contributed module
- A menu that uses `menu_link_content` entities (standard Drupal UI menus).

## Installation
1. Place this module in `web/modules/custom/`  
   or install it with Composer:
   ```bash
   composer require drupal/context_menu_parent_trail
   ```
2. Enable the module and clear caches:
   ```bash
   drush en context_menu_parent_trail -y
   drush cr
   ```

## Usage
1. Go to **Structure → Context** and create or edit a context.
2. Click **Add condition** and select **Menu parent in active trail**.
3. Choose:
   - The **menu** (for example `main`).
   - The **parent menu item** you want to watch.
4. Save the context and configure the desired reactions  
   (for example: show specific blocks, add a CSS class to `<body>`, etc.).

The context will now be activated whenever the selected parent menu item is part of the active trail, which automatically includes all its child and descendant links.

## Development
- Licensed under **GPL-2.0-or-later**.
- Issues, bug reports and patches are welcome in the module’s Drupal.org issue queue.

## Maintenance
This module was created to make it easy to detect whether the current page belongs to a specific parent menu branch when using the Context module.  
Community contributions and improvements are encouraged.