<?php

declare(strict_types=1);

namespace Drupal\context_profile_role\ContextProvider;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Plugin\Context\Context;
use Drupal\Core\Plugin\Context\ContextProviderInterface;
use Drupal\Core\Plugin\Context\EntityContext;
use Drupal\Core\Plugin\Context\EntityContextDefinition;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Sets the user profile as a context on user routes.
 */
class UserProfileRouteContext implements ContextProviderInterface {

  use StringTranslationTrait;

  public function __construct(
    protected RouteMatchInterface $routeMatch,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getRuntimeContexts(array $unqualified_context_ids) {
    $result = [];
    $context_definition = EntityContextDefinition::create('user')->setRequired(FALSE);
    $value = NULL;
    $route_object = $this->routeMatch->getRouteObject();
    if ($route_object !== NULL) {
      /** @var array $route_contexts */
      $route_contexts = $route_object->getOption('parameters');

      if ($route_contexts && isset($route_contexts['user'])) {
        $user = $this->routeMatch->getParameter('user');
        if ($user) {
          $value = $user;
        }
      }
    }

    $cacheability = new CacheableMetadata();
    $cacheability->setCacheContexts(['route']);

    $context = new Context($context_definition, $value);
    $context->addCacheableDependency($cacheability);
    $result['user_profile'] = $context;

    return $result;
  }

  /**
   * {@inheritdoc}
   */
  public function getAvailableContexts() {
    $context = EntityContext::fromEntityTypeId('user', $this->t('User profile from URL'));
    return ['user_profile' => $context];
  }

}
