<?php

namespace Drupal\conword\Plugin\Block;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Access\AccessResultInterface;
use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides 'conword' block.
 */
#[Block(
  id: "conword",
  admin_label: new TranslatableMarkup("Conword"),
)]
class ConwordBlock extends BlockBase implements ContainerFactoryPluginInterface {

  /**
   * The configuration factory.
   */
  protected ConfigFactoryInterface $configFactory;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = new static($configuration, $plugin_id, $plugin_definition);

    $instance->configFactory = $container->get('config.factory');

    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    $config = $this->configFactory->get('conword.settings');

    return [
      '#theme' => 'conword',
      '#attached' => [
        'library' => [
          'conword/conword_ui',
        ],
      ],
      '#cache' => [
        'tags' => $config->getCacheTags(),
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function access(AccountInterface $account, $return_as_object = FALSE): bool|AccessResultInterface {
    $config = $this->configFactory->get('conword.settings');
    $display = $config->get('conwordConfig.disable_language_switcher');

    $access = $display ? AccessResult::allowed() : AccessResult::forbidden();
    return $return_as_object ? $access : $access->isAllowed();
  }

}
