/* global Conword */
(function (Conword) {
  document.addEventListener('DOMContentLoaded', function () {
    const modal = document.querySelector('.conword__modal');
    const languages = Conword.get_available_languages();
    const languageList = document.querySelector('.conword__languages');

    const renderLanguages = () => {
      let html = '';
      Object.entries(languages).forEach((language) => {
        const [langCode, langObj] = language;
        const itemClasses =
          Conword.get_current_language() === langCode
            ? 'conword__language conword__language--active'
            : 'conword__language';
        html += `<li class="${itemClasses}" translate="no"><button class="conword__action conword__action--translate" data-lang="${langCode}">${langObj.name} | ${langObj.name_en}</button></li>`;
      });
      languageList.innerHTML = html;
    };

    const block = document.querySelector('.conword');
    block.addEventListener('click', (event) => {
      const target = event.target;
      if (target.tagName === 'BUTTON' && target.hasAttribute('data-lang')) {
        const language = target.getAttribute('data-lang');
        Conword.translate(language);
        modal.hidePopover();
        renderLanguages();
      }
    });

    renderLanguages();
  });
})(Conword);
