/**
 * @file
 * Defines Javascript behaviors for the cookies addons embed iframe module.
 */
((Drupal, $) => {
  /**
   * Define defaults.
   */
  Drupal.behaviors.cookiesAddonsEmbedIframe = {
    consentGiven(context) {
      $('iframe.cookies-addons-embed-iframe', context).each((i, element) => {
        const $element = $(element);
        if ($element.attr('src') !== $element.data('src')) {
          // We only allow http / https protocols to be used in the 'src'.
          const src = $element.data('src');
          const protocolRegex = /^(https?)/;
          if (src.substring(0, 1) !== '/') {
            const protocol = src.split(':')[0];
            if (!protocolRegex.test(protocol)) {
              // The 'src' is not http nor https, continue to the next element.
              return;
            }
          }
          $element.attr('src', $element.data('src'));
        }
      });
    },

    consentDenied(context) {
      $(
        'iframe.cookies-addons-embed-iframe, div.iframe-embed-lazy',
        context,
      ).cookiesOverlay('iframe');
    },

    attach(context) {
      const self = this;
      document.addEventListener('cookiesjsrUserConsent', (event) => {
        const service =
          typeof event.detail.services === 'object'
            ? event.detail.services
            : {};
        if (typeof service.iframe !== 'undefined' && service.iframe) {
          self.consentGiven(context);
        } else {
          self.consentDenied(context);
        }
      });
    },
  };
})(Drupal, jQuery);
