/**
 * @file
 * Defines JavaScript behaviors for the Cookies Addons fields module.
 */
((Drupal, $) => {
  /**
   * Cookies Addons Fields behavior.
   */
  Drupal.behaviors.cookiesAddonsFields = {
    activate(service, context) {
      $('.cookies-addons-fields-placeholder', context).each(function () {
        if (!$(this).hasClass('request-sent')) {
          const cookiesService = $(this).data('cookies-service');

          if (cookiesService === service) {
            $(this).addClass('request-sent');

            const fieldId = $(this).data('field-id');
            const viewMode = $(this).data('view-mode');

            Drupal.ajax({
              url: `/cookies-addons-fields/get-field/${fieldId}/${service}/${viewMode}`,
              type: 'POST',
            }).execute();
          }
        }
      });
    },

    fallback(service, context) {
      $(
        `.cookies-addons-fields-placeholder[data-cookies-service='${service}']`,
        context,
      ).each(function () {
        const serviceName = $(this).data('service-name');
        $(this).cookiesOverlay(service);
      });
    },

    attach(context) {
      const self = this;

      document.addEventListener('cookiesjsrUserConsent', (event) => {
        const services =
          typeof event.detail.services === 'object'
            ? event.detail.services
            : {};
        $.each(services, (service, accepted) => {
          if (accepted) {
            self.activate(service, context);
          } else {
            self.fallback(service, context);
          }
        });
      });
    },
  };
})(Drupal, jQuery);
