# Copyright Notice Field

Provides a field type to store and display copyright notices.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/copyright_notice).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/copyright_notice).


## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

The copyright notice field can be added to any field-able content type, such as
nodes and blocks. It accepts a year value and a boolean indicating whether to
display the current year. The `copyright-notice.html.twig` template is used to
render the field.

## CONTRIBUTING

Contributions are welcome! You may set up your local development environment
using any stack you prefer. DDEV is optional and supported.

If you choose to use DDEV:

1. Clone the repository.
1. Install DDEV. See [DDEV installation guide](https://docs.ddev.com/en/stable/users/install/).
1. Run the following commands:
   ```
   ddev start
   ddev poser
   ddev symlink-project
   ```
   For more information about the `poser` and `symlink-project` commands, visit
   [ddev-drupal-contrib commands](https://github.com/ddev/ddev-drupal-contrib#commands).

After your environment is ready, you need to install the Drupal site and enable
the module. Drush is available in all setups and can be used as follows:

- Install the site:
  ```
  drush site:install
  ```
- Enable the module:
  ```
  drush pm:install copyright_notice
  ```
