# Copyright Notice Field

Provides a field type to store and display copyright notices. For example, after
adding a copyright notice field to a content type and setting the starting year
to 1982, the field will render as: "Copyright © 1982 - 2025 Your Company Name,
all rights reserved.".

For a full description of the module, visit the
[project page](https://www.drupal.org/project/copyright_notice).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/copyright_notice).


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Navigate to the content type or entity where you want to add the copyright
   notice (e.g., Structure > Content types > [Your type] > Manage fields).
1. Add a new field and select "Copyright notice" as the field type.
1. Configure the field settings.
1. On the "Manage display" tab, configure the formatter settings:
    - **Display current year**: Check to show year ranges (e.g., "1982 - 2025")
    - **Display site name**: Check to include the site name from system
      configuration

The copyright notice will render using the `copyright-notice.html.twig`
template, which can be overridden in your theme.


## Contributing

Contributions are welcome! You may set up your local development environment
using any stack you prefer. DDEV is optional and supported.


### Setting up with DDEV

If you choose to use DDEV:

1. Clone the repository.
1. Install DDEV. See [DDEV installation guide](https://docs.ddev.com/en/stable/users/install/).
1. Run the following commands:
   ```
   ddev start
   ddev poser
   ddev symlink-project
   ```
   For more information about the `poser` and `symlink-project` commands, visit
   [ddev-drupal-contrib commands](https://github.com/ddev/ddev-drupal-contrib#commands).

After your environment is ready, you need to install the Drupal site and enable
the module. Drush is available in all setups and can be used as follows:

- Install the site:
  ```
  drush site:install
  ```
- Enable the module:
  ```
  drush pm:install copyright_notice
  ```
