/**
 * CountdownTimer Effects Module - Consolidated digit animation effects
 * @version 1.0.0-alpha1
 * @license MIT
 *
 * Provides multiple digit-rendering animations: slide, fade, swap, bounce
 * Shared engine with per-effect strategies for optimal performance
 */
!function(e,t){"use strict";"function"==typeof define&&define.amd?define([],t):"object"==typeof module&&module.exports?module.exports=t():t()}("undefined"!=typeof self&&self,(function(){"use strict";const e="undefined"!=typeof window&&window.CountdownTimer||"undefined"!=typeof global&&global.CountdownTimer;if(!e||"function"!=typeof e.registerStyle)return void console.warn("[CountdownTimer.Effects] Core library not found or missing registerStyle");const t={slide:{name:"slide",duration:300,easing:"cubic-bezier(0.4, 0, 0.2, 1)",getInitialState:e=>({transform:`translateY(${100*-e}%)`,opacity:"0"}),getTargetState:e=>({transform:`translateY(${100*e}%)`,opacity:"0"})},fade:{name:"fade",duration:250,easing:"ease-in-out",getInitialState:()=>({transform:"translateY(0)",opacity:"0"}),getTargetState:()=>({transform:"translateY(0)",opacity:"0"})},swap:{name:"swap",duration:100,easing:"linear",getInitialState:()=>({transform:"scale(0.8)",opacity:"0"}),getTargetState:()=>({transform:"scale(1.2)",opacity:"0"})},bounce:{name:"bounce",duration:400,easing:"cubic-bezier(0.68, -0.55, 0.265, 1.55)",getInitialState:e=>({transform:`translateY(${120*-e}%)`,opacity:"0"}),getTargetState:e=>({transform:`translateY(${120*e}%)`,opacity:"0"})}};class i{constructor(e,i={}){this.timer=e,this.element=e._element;const s=i.effect||e.config.style||"slide";this.strategy=t[s]||t.slide,this.options={duration:i.duration||this.strategy.duration,easing:i.easing||this.strategy.easing,...i},this.prevFormatted="",this.isCountdown="countdown"===e.config.mode,this.digitElements=[],this.transitions=new Map,this.timeouts=new Map,this.isDestroyed=!1,this._setupDOM()}_setupDOM(){this.element&&!this.isDestroyed&&(this.element.textContent="",this.element.classList.add("ct-effect"),this.element.classList.add(`ct-effect--${this.strategy.name}`),this.element.style.setProperty("--ct-duration",`${this.options.duration}ms`),this.element.style.setProperty("--ct-easing",this.options.easing),this.element.setAttribute("role","timer"),this.element.setAttribute("aria-live","polite"),this.element.setAttribute("aria-atomic","true"))}render(e,t){if(!this.element||this.isDestroyed)return;const i=e.indexOf("."),s=i>-1;this._ensureDigitContainers(e.length);for(let t=0;t<e.length;t++){const n=e[t],r=t<this.prevFormatted.length?this.prevFormatted[t]:void 0;n!==r&&(s&&t>i?this._snapDigit(t,n):this._animateDigit(t,n,r))}this.prevFormatted=e,this.element.setAttribute("aria-label",this._getAriaLabel(t))}_ensureDigitContainers(e){for(;this.digitElements.length<e;){const e=document.createElement("span");e.className="ct-effect__digit",e.dataset.digitIndex=this.digitElements.length;const t=document.createElement("span");t.className="ct-effect__layer ct-effect__layer--current",t.textContent=" ",e.appendChild(t),this.element.appendChild(e),this.digitElements.push(e)}for(;this.digitElements.length>e;){const e=this.digitElements.pop();this._cleanupDigit(e),e.remove()}}_snapDigit(e,t){const i=this.digitElements[e];if(!i||this.isDestroyed)return;this._cleanupDigit(i);let s=i.querySelector(".ct-effect__layer--current");s||(s=document.createElement("span"),s.className="ct-effect__layer ct-effect__layer--current",i.appendChild(s));i.querySelectorAll(".ct-effect__layer").forEach((e=>{e!==s&&e.remove()})),s.textContent=t,s.style.transform="",s.style.opacity="",s.style.willChange="",s.classList.remove("ct-effect__layer--animating")}_animateDigit(e,t,i){const s=this.digitElements[e];if(!s||this.isDestroyed)return;const n=!window.matchMedia("(prefers-reduced-motion: reduce)").matches;this._cleanupDigit(s);let r=s.querySelector(".ct-effect__layer--current");if(r||(r=document.createElement("span"),r.className="ct-effect__layer ct-effect__layer--current",r.textContent=i||" ",s.appendChild(r)),!n||!i)return void(r.textContent=t);const a=document.createElement("span");a.className="ct-effect__layer ct-effect__layer--incoming",a.textContent=t;const o=this.isCountdown?-1:1,l=this.strategy.getInitialState(o),c=this.strategy.getTargetState(o);Object.assign(a.style,l),a.style.willChange="transform, opacity",s.appendChild(a),s.offsetHeight,r.classList.add("ct-effect__layer--animating"),a.classList.add("ct-effect__layer--animating"),r.style.willChange="transform, opacity",requestAnimationFrame((()=>{this.isDestroyed||(Object.assign(r.style,c),a.style.transform="translateY(0) scale(1)",a.style.opacity="1")}));const m={currentLayer:r,incomingLayer:a,container:s,completed:!1,transitionEndHandler:null};this.transitions.set(e,m);const d=()=>{if(m.completed||this.isDestroyed)return;m.completed=!0,r.parentNode===s&&r.remove(),a.classList.remove("ct-effect__layer--animating","ct-effect__layer--incoming"),a.classList.add("ct-effect__layer--current"),a.style.transform="",a.style.opacity="",a.style.willChange="";const t=this.timeouts.get(e);t&&(clearTimeout(t),this.timeouts.delete(e)),this.transitions.delete(e)},f=e=>{e.target===a&&"transform"===e.propertyName&&d()};a.addEventListener("transitionend",f),m.transitionEndHandler={element:a,handler:f};const h=setTimeout(d,this.options.duration+50);this.timeouts.set(e,h)}_cleanupDigit(e){const t=parseInt(e.dataset.digitIndex,10),i=this.timeouts.get(t);i&&(clearTimeout(i),this.timeouts.delete(t));const s=this.transitions.get(t);if(s&&!s.completed){if(s.completed=!0,s.transitionEndHandler){const{element:e,handler:t}=s.transitionEndHandler;e.removeEventListener("transitionend",t)}s.currentLayer&&(s.currentLayer.classList.remove("ct-effect__layer--animating"),s.currentLayer.style.willChange="",s.currentLayer.parentNode&&s.currentLayer.remove()),s.incomingLayer&&(s.incomingLayer.classList.remove("ct-effect__layer--animating","ct-effect__layer--incoming"),s.incomingLayer.classList.add("ct-effect__layer--current"),s.incomingLayer.style.transform="",s.incomingLayer.style.opacity="",s.incomingLayer.style.willChange=""),this.transitions.delete(t)}}_getAriaLabel(e){const t=[];return e.days>0&&t.push(`${e.days} day${1!==e.days?"s":""}`),e.hours>0&&t.push(`${e.hours} hour${1!==e.hours?"s":""}`),e.minutes>0&&t.push(`${e.minutes} minute${1!==e.minutes?"s":""}`),e.seconds>0&&t.push(`${e.seconds} second${1!==e.seconds?"s":""}`),e.milliseconds>0&&0===t.length&&t.push(`${e.milliseconds} milliseconds`),t.join(", ")||"0 seconds"}destroy(){this.isDestroyed=!0;for(const e of this.timeouts.values())clearTimeout(e);this.timeouts.clear();for(const e of this.transitions.values())if(!e.completed){if(e.completed=!0,e.transitionEndHandler){const{element:t,handler:i}=e.transitionEndHandler;t.removeEventListener("transitionend",i)}e.currentLayer&&e.currentLayer.parentNode&&e.currentLayer.remove(),e.incomingLayer&&(e.incomingLayer.style.willChange="")}this.transitions.clear(),this.element&&(this.element.classList.remove("ct-effect",`ct-effect--${this.strategy.name}`),this.element.style.removeProperty("--ct-duration"),this.element.style.removeProperty("--ct-easing"),this.element.removeAttribute("role"),this.element.removeAttribute("aria-live"),this.element.removeAttribute("aria-atomic"),this.element.removeAttribute("aria-label"),this.element.textContent=""),this.digitElements=[],this.timer=null,this.element=null}}return Object.keys(t).forEach((t=>{e.registerStyle(t,i)})),"function"==typeof e.registerEffect&&Object.keys(t).forEach((t=>{e.registerEffect(t,i)})),i}));
