<?php

declare(strict_types=1);

namespace Drupal\countdown\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Countdown library plugin annotation.
 *
 * Use this annotation to register a countdown assets provider. It declares
 * metadata used by the plugin manager to discover and load libraries.
 *
 * @Annotation
 */
class CountdownLibrary extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable label.
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $label;

  /**
   * The description shown in administration screens.
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $description;

  /**
   * The library type, either "core" or "external".
   *
   * @var string
   */
  public $type = 'external';

  /**
   * The minimum required version for local installations.
   *
   * @var string|null
   */
  public $version;

  /**
   * A list of alternative folder names to probe during discovery.
   *
   * @var string[]
   */
  public $folder_names = [];

  /**
   * Required files relative to the detected library root.
   *
   * @var string[]
   */
  public $required_files = [];

  /**
   * Alternative sets of files that also satisfy validation.
   *
   * @var array<int, string[]>
   */
  public $alternative_paths = [];

  /**
   * Optional local file map for legacy, non-declarative assets.
   *
   * Expected keys:
   * - js: ['production' => '...', 'development' => '...']
   * - css: ['production' => '...', 'development' => '...']
   *
   * @var array<string, array<string, string>>
   */
  public $files = [];

  /**
   * CDN configuration keyed by provider.
   *
   * Each provider entry may declare:
   * - js / js_min: URLs for JS assets.
   * - css / css_min: URLs for CSS assets.
   *
   * @var array<string, array<string, string>>
   */
  public $cdn = [];

  /**
   * The NPM package name used for discovery and CDN building.
   *
   * @var string|null
   */
  public $npm_package;

  /**
   * Drupal library dependencies to add to the definition.
   *
   * @var string[]
   */
  public $dependencies = [];

  /**
   * The library homepage for administrator reference.
   *
   * @var string|null
   */
  public $homepage;

  /**
   * The code repository URL for the library.
   *
   * @var string|null
   */
  public $repository;

  /**
   * The library author or organization.
   *
   * @var string|null
   */
  public $author;

  /**
   * The SPDX license identifier when known.
   *
   * @var string|null
   */
  public $license;

  /**
   * Whether the plugin is experimental.
   *
   * @var bool
   */
  public $experimental = FALSE;

  /**
   * Sort weight for listing and option ordering.
   *
   * @var int
   */
  public $weight = 0;

  /**
   * The JavaScript init function exposed by the library.
   *
   * @var string|null
   */
  public $init_function;

}
