<?php

declare(strict_types=1);

namespace Drupal\countdown;

/**
 * Defines essential constants for the Countdown module.
 *
 * Only cross-cutting identifiers that appear in multiple files are defined
 * here. Config keys are accessed via ConfigAccessor, not constants.
 */
final class CountdownConstants {

  /**
   * Default library when none is configured or available.
   */
  const DEFAULT_LIBRARY = 'countdown';

  /**
   * Cache tags for invalidation.
   */
  const CACHE_TAG_DISCOVERY = 'countdown:library_discovery';
  const CACHE_TAG_SETTINGS = 'countdown:settings';

  /**
   * Cache bin for discovery.
   */
  const CACHE_BIN_DISCOVERY = 'discovery';

  /**
   * Default cache lifetime in seconds (24 hours).
   */
  const CACHE_MAX_AGE = 86400;

  /**
   * Permission for administration.
   */
  const PERMISSION_ADMINISTER = 'administer countdown';

  /**
   * Query parameter to disable countdown on a page.
   */
  const QUERY_PARAM_DISABLE = 'countdown';

  /**
   * Known CDN providers.
   */
  const CDN_PROVIDER_JSDELIVR = 'jsdelivr';
  const CDN_PROVIDER_CDNJS = 'cdnjs';
  const CDN_PROVIDER_UNPKG = 'unpkg';
  const CDN_PROVIDER_CUSTOM = 'custom';

}
