# Countries

Countries import is a module that imports Countries or areas / geographical 
regions following the 
[M49 standard] containing 
information like country codes from ISO 3166-1 / 3166-2 
(i.e. RO, ROU for România), name, official name or flag.
The information can be stored as terms or nodes based on the configuration.

## Installation

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/docs/extending-drupal/installing-modules for 
further information.

## Configuration

* Configure the Countries import in Configuration » Content authoring » 
Countries import.
* Configure the:
    * Countries settings (`/admin/config/content/countries-import`)
    * Geographic Regions settings
(`/admin/config/content/countries-import/geographic-regions`)

## Options

This works by providing multiple options to control what should happen when the
entity is being created. You have the ability to:
* Select where to store the information (Content type or Taxonomy).
* In which fields to store each information.
* The flag format (SVG, PNG format (32x16), PNG format (128x64)).
* Possibility to translate the name and the official name.
* Possibility to import the assignment of countries to regions (since 2.0.x).
* Possibility to import only countries/regions.

## References
- [M49 standard]
- [Database]

[M49 standard]: https://unstats.un.org/unsd/methodology/m49
[Database]: https://github.com/cristiroma/countries