/**
 * @file
 * Attach Coveo atomic interface.
 */

(function ($, Drupal) {
  /**
   * Wrapper object for the current state of the media library.
   */
  Drupal.CoveoAtomic = {
    /**
     * Refresh a Coveo search token.
     *
     * @param {string} search
     *   Coveo search implementation to generate a token for.
     * @return {function(): Promise<null|*>}
     *   Callback able to return a new search token.
     */
    refreshSearchToken(search) {
      // TODO what is the correct ID here?
      // https://docs.coveo.com/en/56/build-a-search-ui/use-search-token-authentication
      // I think this works...
      return async () => {
        const data = await $.getJSON('/coveo/refresh', { search });
        return data.token;
      };
    },
    analyticsClientMiddleware(searchInterface, eventName, payload) {
      return payload;
    },
  };

  async function attachCoveoAtomic(settings) {
    await customElements.whenDefined('atomic-search-interface');
    const searchInterface = settings.element;

    await searchInterface.initialize({
      accessToken: settings.accessToken,
      organizationId: settings.organizationId,
      renewAccessToken: Drupal.CoveoAtomic.refreshSearchToken(settings.search),
      analytics: {
        analyticsMode: settings.analyticsMode || 'legacy',
        analyticsClientMiddleware: (eventName, payload) => Drupal.CoveoAtomic.analyticsClientMiddleware(searchInterface, eventName, payload),
      },
    });
    searchInterface.executeFirstSearch();
  }

  Drupal.behaviors.coveoAtomic = {
    attach(context, settings) {
      function loadAtomic(base) {
        const atomicSettings = settings.coveo_atomic[base];
        if (typeof atomicSettings.selector === 'undefined') {
          atomicSettings.selector = `#${base}`;
        }
        once('coveo-atomic', atomicSettings.selector).forEach((el) => {
          atomicSettings.element = el;
          attachCoveoAtomic(atomicSettings);
        });
      }

      Object.keys(settings.coveo_atomic || {}).forEach(loadAtomic);
    },
  };
})(jQuery, Drupal);
