<?php

declare(strict_types=1);

namespace Drupal\coveo_atomic\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Atomic block deriver.
 */
class CoveoAtomicBlocks extends DeriverBase implements ContainerDeriverInterface {

  /**
   * Constructs a base class for Coveo search add and edit forms.
   *
   * @param \Drupal\Core\Entity\EntityStorageInterface $searchStorage
   *   The Coveo search entity storage.
   */
  public function __construct(
    protected EntityStorageInterface $searchStorage,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    $entity_type_manager = $container->get('entity_type.manager');
    return new static(
      $entity_type_manager->getStorage('coveo_search_component')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    /** @var \Drupal\coveo\Entity\CoveoSearchComponentInterface[] $search_components */
    $search_components = $this->searchStorage->loadByProperties();
    // Reset the discovered definitions.
    $this->derivatives = [];
    foreach ($search_components as $search_component) {
      $this->derivatives[$search_component->id()] = $base_plugin_definition;
      $this->derivatives[$search_component->id()]['admin_label'] = 'Coveo Atomic: ' . $search_component->label();
      $this->derivatives[$search_component->id()]['config_dependencies']['content'] = [
        $search_component->getConfigDependencyName(),
      ];
    }
    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

}
