<?php

declare(strict_types=1);

namespace Drupal\coveo\API;

use GuzzleHttp\ClientInterface;
use NecLimDul\Coveo\FieldApi\Configuration;

/**
 * Field API service factory.
 */
class FieldApiFactory {

  /**
   * API factory service.
   *
   * @var \Drupal\coveo\API\ApiFactory
   */
  private ApiFactory $factory;

  public function __construct(ClientInterface $client) {
    $this->factory = new ApiFactory($client);
  }

  /**
   * Create a FieldApi service.
   *
   * @param class-string<T> $class
   *   A FieldApi service class.
   * @param string $token
   *   An access token with admin privileges.
   *
   * @return T
   *   The instantiated API service.
   *
   * @template T
   */
  public function create(
    string $class,
    #[\SensitiveParameter]
    string $token,
  ) {
    $config = new Configuration();
    $config->setAccessToken($token);
    return $this->factory->create($class, $config);
  }

}
