<?php

declare(strict_types=1);

namespace Drupal\coveo\API;

use GuzzleHttp\ClientInterface;
use NecLimDul\Coveo\SecurityCache\Configuration;

/**
 * Search Cache service factory.
 *
 * @see https://platform.cloud.coveo.com/docs?urls.primaryName=SecurityCache#/
 */
class SecurityCacheFactory {

  /**
   * API factory service.
   *
   * @var \Drupal\coveo\API\ApiFactory
   */
  private ApiFactory $factory;

  public function __construct(ClientInterface $client) {
    $this->factory = new ApiFactory($client);
  }

  /**
   * Create a SecurityCache service.
   *
   * @param class-string<T> $class
   *   A SecurityCache service class.
   * @param string $token
   *   An access token with admin privileges.
   *
   * @return T
   *   The instantiated API service.
   *
   * @template T
   */
  public function create(
    string $class,
    #[\SensitiveParameter]
    string $token,
  ) {
    $config = new Configuration();
    $config->setAccessToken($token);
    return $this->factory->create($class, $config);
  }

}
