<?php

declare(strict_types=1);

namespace Drupal\coveo\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\coveo\Entity\CoveoOrganizationInterface;

/**
 * Coveo organization overview controller class.
 */
class OrganizationOverview extends ControllerBase {

  /**
   * Page title callback.
   *
   * @param \Drupal\coveo\Entity\CoveoOrganizationInterface $coveo_organization
   *   Coveo organization.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|string|null
   *   Page title.
   */
  public function title(CoveoOrganizationInterface $coveo_organization): string|TranslatableMarkup|null {
    return $coveo_organization->label();
  }

  /**
   * Coveo organization overview controller callback.
   *
   * @param \Drupal\coveo\Entity\CoveoOrganizationInterface $coveo_organization
   *   Coveo organization.
   *
   * @return array
   *   Render array with page contents.
   */
  public function overview(CoveoOrganizationInterface $coveo_organization) {
    return [
      '#markup' => 'Future home of organization overview',
    ];
  }

}
