<?php

namespace Drupal\Tests\coveo\Unit\API\Model;

use Drupal\coveo\API\Model\DeletedItem;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\coveo\API\Model\DeletedItem
 */
class DeletedItemTest extends TestCase {

  /**
   * System under test.
   */
  private DeletedItem $sot;

  /**
   * {@inheritDoc}
   */
  public function setUp(): void {
    parent::setUp();
    $this->sot = new DeletedItem([
      'document_id' => 'default_id',
      'delete_children' => FALSE,
    ]);
  }

  /**
   * @covers ::getDocumentId
   * @covers ::setDocumentId
   */
  public function testGetDocumentId(): void {
    $this->assertEquals(
      'default_id',
      $this->sot->getDocumentId(),
    );
    $this->sot->setDocumentId('new_id');
    $this->assertEquals(
      'new_id',
      $this->sot->getDocumentId(),
    );
  }

  /**
   * @covers ::getDeleteChildren
   * @covers ::setDeleteChildren
   */
  public function testGetDeleteChildren(): void {
    $this->assertFalse($this->sot->getDeleteChildren());
    $this->sot->setDeleteChildren(TRUE);
    $this->assertTrue($this->sot->getDeleteChildren());
  }

  /**
   * @covers ::jsonSerialize
   */
  public function testJsonSerialize(): void {
    $this->assertEquals(
      '{"documentId":"default_id","deleteChildren":false}',
      json_encode($this->sot),
    );
    $this->sot->setDocumentId('new_id');
    $this->sot->setDeleteChildren(TRUE);
    $this->assertEquals(
      '{"documentId":"new_id","deleteChildren":true}',
      json_encode($this->sot),
    );
  }

}
