# Coveo (Search API)

## Introduction

The Coveo module manages its dependencies and class loader via
composer. So if you simply downloaded this module from drupal.org you have to
delete it and install it again via composer!

## How it works

This module provides an implementation of the Search API which uses a Coveo Push
source for indexing and searching.

## Coveo Quick Setup

Coveo has been doing a lot of updates to their permission model but this guide tries to capture everything you need to do to get started. If something is broken please file a bug so we can get it updated.

1. Create a new push source
   - Navigate to `Content -> Sources`
   - Click the `Add source` action to add a new source.
   - Select `Push` from the list.
   - Add a name.
   - Don't select "Create an API key", we'll add one in a second. With better permissions.
   - Under `Content security`, if you're going to secure your content select "Same users and groups as in your current permissions system", otherwise leave "Everyone" for a fully public search.
2. Create a Push API key
   - This key will be used to push data to your index.
   - To create follow these steps:
     - Navigate to `Organization -> API Keys`
     - Click the `Add key` action to add a new key.
     - Select `Custom` from the Key purposes
     - Give the key a `Name` and description if desired
     - Give the custom key the following `Privileges`
         - | Path                                             | Permissions                                      | Notes                                                                                                             |
           |--------------------------------------------------|--------------------------------------------------|-------------------------------------------------------------------------------------------------------------------|
           | Content -> Fields                                | Edit                                             |                                                                                                                   |
           | Content -> Push identities to security providers | Allow for all providers                          | Optional. You need all because you'll create the custom provider in Drupal and you won't know the ID before hand. |
           | Content -> Push items to sources                 | Custom (Select your push source and allow)       |                                                                                                                   |
           | Organization -> Organization                     | View                                             |                                                                                                                   |
           | Content -> Security identity                     | Edit                                             | Optional. Custom security providers                                                                               |
           | Content -> Security identity providers           | Edit                                             | Optional. Custom security providers                                                                               |
           | Content -> Sources                               | Custom (Select your push source and select Edit) | Optional. File indexing                                                                                           |
           | Organization -> Organization                     | View                                             | Required to create file containers for batch operations.                                                          |
     - Choose a renewal that makes sense to your deployment strategy.
     - Compete the rest of the wizard
     - Make sure you copy the key, it will not be shown again.
3. Create a SearchApi API key.
  - This key will allow us to query the organization.
    - Supports Admin audit queries.
    - Supports SearchAPI queries though things like Views.
  - To create follow these steps:
    - Create a "Search pages" key.
    - Make sure to copy your key, it will not be displayed again!
4. Create a Coveo server instances in Search API
  - Add the organization ID from your Coveo instance. You can find it in the organizations switcher in the top navigation.
  - Copy the Source ID from your previously created source and add it to your Search API server
  - Populate the "Push API Key" with the API key created with your push source
  - Populate the "Search API Key" with the second API key.
5. Create indexes and define index fields
  - Name one field `coveo_data` to populate the data and description values in coveo. This field is what will be used for the search model so it may be your Body, or you may want some sort of rendered content.
  - Name one field `coveo_title` to populate the internal Coveo title.
  - Optionally name additional fields with the `coveo_` prefix to map them to internal Coveo fields.

You should now be able to use SearchAPI as normal to index content into Coveo.

### Setup Drupal
 - Add key and organization id to the Coveo settings page.

## Indexing Batch Sync process

```mermaid
sequenceDiagram
  participant Drupal as Drupal
  participant CoveoPush as Coveo PushApi
  participant AWS as AWS

  loop Foreach compressedBinaryDataFileId, upload the file
    Drupal ->>+ CoveoPush: POST /files (Create file uri)
    CoveoPush -->>- Drupal: Return uploadUri, fieldId
    Drupal ->>+ AWS: PUT uploadUri (Upload file attachment)
    AWS -->>- Drupal: Success
    Note right of Drupal: Replace compressedBinaryDataFileId in batch document with fileId
  end
  Drupal ->>+ CoveoPush: POST /files (Create batch uri)
  CoveoPush -->>- Drupal: Return uploadUri, fieldId
  Drupal ->>+ AWS: PUT uploadUri (Upload batch document)
  AWS -->>- Drupal: Success
  Drupal ->>+ CoveoPush: PUT /sources/.../batch(fileId) (Tell Coveo about batch)
  CoveoPush -->>- Drupal: Return Success
```

### TODO
 - Audit all the TODOs
 - TODO better configure field definitions. Fulltext. Stemming. Other types?
 - Fix custom security provider deletion.
 - Document how to make file indexing work.
