<?php

declare(strict_types=1);

namespace Drupal\coveo_atomic\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Hook implementations for coveo_atomic.
 */
class CoveoAtomicHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) {
    switch ($route_name) {
      case 'help.page.coveo_atomic':
        return 'https://docs.coveo.com/en/atomic/latest/';
    }
  }

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme(): array {
    $theme = [];

    $theme['coveo_atomic_search'] = [
      'template' => 'coveo-atomic-search',
      'variables' => [
        'id' => 'search',
        'search' => '',
        'fields' => ['coveo_uri', 'coveo_date', 'coveo_excerpt'],
        'facets' => [],
        'tabs' => [],
      ],
    ];

    return $theme;
  }

  /**
   * Implements hook_theme_suggestions_HOOK().
   */
  #[Hook('theme_suggestions_coveo_atomic_search')]
  public function themeSuggestionsCoveoAtomicSearch(array $variables): array {
    return [
      'coveo_atomic_search__' . strtr($variables['id'], '-', '_'),
    ];
  }

}
