<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\TypedData\TypedData;
use Drupal\file\FileInterface;

/**
 * Hacky TypedData type to handle file uri processing.
 */
class ComputedFileUriAbsolute extends TypedData {

  /**
   * Computed root-relative file URL.
   *
   * @var string|null
   */
  protected ?string $url = NULL;

  /**
   * {@inheritdoc}
   */
  public function getValue(): string {
    if ($this->url !== NULL) {
      return $this->url;
    }

    $parent = $this->getParent();
    assert($parent instanceof FieldItemListInterface);
    $entity = $parent->getEntity();
    assert($entity instanceof FileInterface);

    $uri = $entity->getFileUri();
    /** @var \Drupal\Core\File\FileUrlGeneratorInterface $file_url_generator */
    $file_url_generator = \Drupal::service('file_url_generator');
    $this->url = $file_url_generator->generateAbsoluteString($uri);

    return $this->url;
  }

  /**
   * {@inheritdoc}
   */
  public function setValue($value, $notify = TRUE): void {
    $this->url = $value;

    // Notify the parent of any changes.
    if ($notify && isset($this->parent)) {
      $this->parent->onChange($this->name);
    }
  }

}
