<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\search_api\IndexInterface;

/**
 * Event that allows altering of documents before being sent to batch operation.
 */
class CoveoDocumentsAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \Drupal\coveo\DocumentBody[] $objects
   *   Documents to be altered.
   * @param \Drupal\search_api\Item\ItemInterface[] $items
   *   An array of items to be indexed, keyed by their item IDs.
   * @param \Drupal\search_api\IndexInterface $index
   *   The index the documents will be pushed to.
   */
  public function __construct(public array &$objects, public readonly array $items, public readonly IndexInterface $index) {}

}
