<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Url;
use Drupal\coveo_secured_search\Entity\CoveoCustomSecurityProvider;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a class to build a listing of Coveo search entities.
 *
 * @see \Drupal\coveo\Entity\CoveoSearchComponent
 */
class CustomSecurityProviderListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritDoc}
   */
  public static function createInstance(
    ContainerInterface $container,
    EntityTypeInterface $entity_type,
  ) {
    return new static(
      $entity_type,
      $container->get('entity_type.manager')->getStorage($entity_type->id()),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Security Provider');
    $header['description'] = $this->t('Description');
    $header['organization'] = $this->t('Organization');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    assert($entity instanceof CoveoCustomSecurityProvider);
    $row['label'] = $entity->label();
    $row['description'] = $entity->get('description');
    $row['organization'] = $entity->getOrganization()?->label();
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();
    $build['table']['#weight'] = 1;
    $build['table']['#empty'] = $this->t('There are currently no Coveo security providers defined. <a href=":url">Add a new one</a>.', [
      ':url' => Url::fromRoute('entity.coveo_custom_security_provider.add_form')->toString(),
    ]);
    return $build;
  }

}
