<?php

namespace Drupal\coveo\Coveo;

use Drupal\coveo\Entity\CoveoOrganizationInterface;
use GuzzleHttp\Client as GuzzleClient;
use NecLimDul\Coveo\PushApi\Api\FileContainerApi;
use NecLimDul\Coveo\PushApi\Api\ItemApi;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Indexing helper factory.
 *
 * Helps with dependency injection.
 */
readonly class IndexHelperFactory {

  public function __construct(
    private GuzzleClient $httpClient,
    private EventDispatcherInterface $eventDispatcher,
    private LoggerInterface $logger,
  ) {
  }

  /**
   * Create an index helper for an organization.
   *
   * @param \Drupal\coveo\Entity\CoveoOrganizationInterface $organization
   *   A coveo organization.
   *
   * @return \Drupal\coveo\Coveo\Index
   *   The indexing helper.
   */
  public function createIndex(CoveoOrganizationInterface $organization): Index {
    return new Index(
      $organization->getOrganizationId(),
      $this->httpClient,
      $organization->pushApiCreate(FileContainerApi::class),
      $organization->pushApiCreate(ItemApi::class),
      $this->logger,
      $this->eventDispatcher,
    );
  }

}
