<?php

declare(strict_types=1);

namespace Drupal\coveo\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use NecLimDul\Coveo\SearchApi\Api\SearchV2Api;

/**
 * Coveo search entity.
 */
interface CoveoSearchComponentInterface extends ConfigEntityInterface {

  /**
   * The search key used to generate authentication tokens.
   *
   * @return string|null
   *   The key/token used to connect to the search api for authentication.
   */
  public function searchKey(): string|null;

  /**
   * Get a Coveo Search V2 API instance.
   *
   * @return \NecLimDul\Coveo\SearchApi\Api\SearchV2Api
   *   The SearchV2API instance.
   */
  public function getSearchApi(): SearchV2Api;

  /**
   * The Organization ID to search.
   *
   * @return string|null
   *   The associated organization ID.
   */
  public function getOrganizationId(): string|null;

  /**
   * The Organization ID to search.
   *
   * @return string|null
   *   The associated organization ID.
   */
  public function getOrganizationName(): string|null;

  /**
   * Get the associated organization config.
   *
   * @return \Drupal\coveo\Entity\CoveoOrganizationInterface|null
   *   Organization config.
   */
  public function getOrganization(): CoveoOrganizationInterface|null;

  /**
   * Get the plugin ID of the associated security provider.
   *
   * @return string|null
   *   The associated security provider plugin ID.
   */
  public function getSecurityProviderId(): string|null;

}
