<?php

declare(strict_types=1);

namespace Drupal\coveo\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\coveo\API\Model\BatchDocumentBody;
use Drupal\coveo\Coveo\Index;

/**
 * Event that allows altering of documents before being sent to batch operation.
 */
class CoveoBatchAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \Drupal\coveo\API\Model\BatchDocumentBody $batch
   *   Batch document to alter.
   * @param \Drupal\coveo\Coveo\Index $index
   *   Index helper.
   */
  public function __construct(public readonly BatchDocumentBody $batch, public readonly Index $index) {}

}
