<?php

declare(strict_types=1);

namespace Drupal\coveo\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Hook implementations for coveo.
 */
class CoveoHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) {
    switch ($route_name) {
      case 'coveo.security_providers':
        return '<p>' . t('Security providers provide a method for generating tokens for search components.') . '</p>' .
          '<p><a href="https://example.com">TODO provider docs.</a></p>';

      case 'entity.coveo_search_component.collection':
        return '<p>' . t('Coveo search components facilitate interfaces using Coveo Atomic and Coveo Headless searches.') . '</p>' .
          '<p><a href="https://docs.coveo.com/en/56/build-a-search-ui/use-search-token-authentication">https://docs.coveo.com/en/56/build-a-search-ui/use-search-token-authentication</a></p>';
    }
  }

}
