<?php

declare(strict_types=1);

namespace Drupal\coveo\Plugin\Coveo\SecurityProvider;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\coveo\Attribute\CoveoSecurityProvider;

/**
 * Email Provider security provider.
 *
 * Generates tokens for the out-of-the-box Coveo Email Token Security Provider.
 */
#[CoveoSecurityProvider(
  id: 'email_provider',
  title: new TranslatableMarkup('Email Provider'),
  description: new TranslatableMarkup("Out-of-the-box Coveo Email Provider populate with the current user's email address."),
)]
class EmailProvider extends AbstractSecuredUserProvider implements ContainerFactoryPluginInterface {

  /**
   * {@inheritDoc}
   */
  #[\Override]
  public function getIdentityProviderId(): string {
    return 'Email Security Provider';
  }

  /**
   * {@inheritDoc}
   */
  #[\Override]
  protected function getName(AccountInterface $account): string {
    return $account->getEmail() ?? 'anon@example.com';
  }

}
