<?php

declare(strict_types=1);

namespace Drupal\coveo\Plugin;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\CategorizingPluginManagerTrait;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\coveo\Annotation\CoveoSecurityProvider as CoveoSecurityProviderAnnotation;
use Drupal\coveo\Attribute\CoveoSecurityProvider;

/**
 * Coveo security provider plugin manager.
 *
 * Provides a method for replacing various security provider strategies.
 *
 * @see https://docs.coveo.com/en/atomic/latest/usage/#use-components-to-create-a-search-interface
 * @see https://docs.coveo.com/en/1718/manage-an-organization/manage-api-keys#api-key-templates
 * @see https://docs.coveo.com/en/56/build-a-search-ui/use-search-token-authentication
 */
class CoveoSecurityProviderManager extends DefaultPluginManager implements CoveoSecurityProviderManagerInterface {

  use CategorizingPluginManagerTrait {
    getSortedDefinitions as traitGetSortedDefinitions;
  }

  /**
   * Construct a token generator manager.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
      'Plugin/Coveo/SecurityProvider',
      $namespaces,
      $module_handler,
      CoveoSecurityProviderPluginInterface::class,
      CoveoSecurityProvider::class,
      CoveoSecurityProviderAnnotation::class
    );
    $this->setCacheBackend($cache_backend, 'coveo_security_provider');
  }

  /**
   * {@inheritdoc}
   */
  public function getSortedDefinitions(?array $definitions = NULL) {
    return $this->traitGetSortedDefinitions($definitions, 'title');
  }

}
