<?php

namespace Drupal\Tests\coveo\Unit\API;

use Drupal\coveo\API\ApiFactory;
use GuzzleHttp\Client;
use NecLimDul\Coveo\FieldApi\Api\FieldsApi;
use NecLimDul\Coveo\FieldApi\Configuration;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\coveo\API\ApiFactory
 */
class ApiFactoryTest extends TestCase {

  /**
   * @covers ::create
   */
  public function testCreate(): void {
    $client = new Client();
    $config = new Configuration();
    $sot = new ApiFactory($client);
    $service = $sot->create(FieldsApi::class, $config);
    $this->assertInstanceOf(FieldsApi::class, $service);
    $this->assertSame($config, $service->getConfig());
  }

}
