<?php

namespace Drupal\Tests\coveo\Unit\API\Model;

use Drupal\coveo\API\Model\BatchDocumentBody;
use Drupal\coveo\API\Model\DeletedItem;
use Drupal\coveo\DocumentBody;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\coveo\API\Model\BatchDocumentBody
 */
class BatchDocumentBodyTest extends TestCase {

  /**
   * System under test.
   */
  private BatchDocumentBody $sot;

  /**
   * {@inheritDoc}
   */
  public function setUp(): void {
    parent::setUp();
    $this->sot = new BatchDocumentBody([
      'delete' => [],
      'add_or_update' => [],
    ]);
  }

  /**
   * @covers ::setDelete
   * @covers ::getDelete
   */
  public function testGetDelete(): void {
    $this->assertEquals([], $this->sot->getDelete());
    $delete = [
      new DeletedItem(),
    ];
    $this->sot->setDelete($delete);
    $this->assertEquals($delete, $this->sot->getDelete());

  }

  /**
   * @covers ::setAddOrUpdate
   * @covers ::getAddOrUpdate
   */
  public function testGetAddOrUpdate(): void {
    $this->assertEquals([], $this->sot->getAddOrUpdate());
    $add_or_update = [
      new DocumentBody(),
      new DocumentBody(),
    ];
    $this->sot->setAddOrUpdate($add_or_update);
    $this->assertSame($add_or_update, $this->sot->getAddOrUpdate());
  }

  /**
   * @covers ::jsonSerialize
   */
  public function testJsonSerialize(): void {
    $this->assertEquals(
      '{"addOrUpdate":[],"delete":[]}',
      json_encode($this->sot),
    );
    $document1 = new DocumentBody();
    $document1->setAdditionalProperties([
      'documentId' => 'example.com/node/1',
    ]);
    $document2 = new DocumentBody();
    $document2->setAdditionalProperties([
      'documentId' => 'example.com/node/2',
    ]);
    $this->sot->setAddOrUpdate([
      $document1,
      $document2,
    ]);
    $this->assertEquals(
      '{"addOrUpdate":[{"documentId":"example.com\/node\/1"},{"documentId":"example.com\/node\/2"}],"delete":[]}',
      json_encode($this->sot),
    );
  }

}
