<?php

namespace Drupal\Tests\coveo\Unit\API;

use Drupal\coveo\API\PushApiFactory;
use GuzzleHttp\Client;
use NecLimDul\Coveo\PushApi\Api\ItemApi;
use PHPUnit\Framework\TestCase;

/**
 * @coversDefaultClass \Drupal\coveo\API\PushApiFactory
 */
class PushApiFactoryTest extends TestCase {

  /**
   * @covers ::create
   */
  public function testCreate(): void {
    $client = new Client();
    $sot = new PushApiFactory($client);
    $service = $sot->create(ItemApi::class, 'test123');
    $this->assertInstanceOf(ItemApi::class, $service);
    $this->assertSame('test123', $service->getConfig()->getAccessToken());
  }

}
