<?php

declare(strict_types=1);

namespace Drupal\coveo_atomic\Plugin\Block;

use Drupal\Core\Block\Attribute\Block;
use Drupal\Core\Block\BlockBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\coveo_atomic\Plugin\Derivative\CoveoAtomicBlocks;

/**
 * Provides a Coveo Atomic Search Block.
 */
#[Block(
  id: 'coveo_atomic',
  admin_label: new TranslatableMarkup('Coveo Atomic Search'),
  category: new TranslatableMarkup('Search'),
  deriver: CoveoAtomicBlocks::class,
)]
class CoveoAtomicSearch extends BlockBase {

  /**
   * {@inheritDoc}
   */
  public function build(): array {
    return [
      '#theme' => 'coveo_atomic_search',
      '#id' => $this->configuration['widget_id'],
      '#search' => $this->getDerivativeId(),
      '#contextual_links' => [
        'entity.coveo_search_component.edit_form' => [
          'route_parameters' => [
            'coveo_search_component' => $this->getDerivativeId(),
          ],
        ],
      ],
    ];
  }

  /**
   * {@inheritDoc}
   */
  public function defaultConfiguration(): array {
    return [
      'widget_id'  => '',
    ];
  }

  /**
   * {@inheritDoc}
   */
  public function blockForm($form, FormStateInterface $form_state): array {
    // This is a hack... Probably something smarter to do here.
    $form['widget_id'] = [
      '#title' => 'Coveo Widget ID',
      '#description' => 'Placement ID.',
      '#type' => 'machine_name',
      '#machine_name' => [
        // We don't care about uniqueness atm, only the validation.
        'exists' => fn() => FALSE,
      ],
      '#default_value' => $this->configuration['widget_id'],
      '#required' => TRUE,
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function blockSubmit($form, FormStateInterface $form_state): void {
    $this->configuration['widget_id'] = $form_state->getValues()['widget_id'];
  }

}
