<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\search_api\Item\ItemInterface;
use NecLimDul\Coveo\PushApi\Model\DocumentBody;

/**
 * Event that allows altering of individual documents before being indexed.
 */
class CoveoDocumentAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \NecLimDul\Coveo\PushApi\Model\DocumentBody $document
   *   Document to be altered.
   * @param \Drupal\search_api\Item\ItemInterface $item
   *   The item used to generate the document.
   */
  public function __construct(public readonly DocumentBody $document, public readonly ItemInterface $item) {}

}
