<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\coveo\Entity\CoveoOrganizationInterface;

/**
 * Event to allow the altering of a search token during generation.
 *
 * @phpstan-import-type FieldData from \Drupal\coveo_search_api\SyncFields
 * @phpstan-import-type FieldOperations from \Drupal\coveo_search_api\SyncFields
 */
class CoveoFieldDataAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \Drupal\coveo\Entity\CoveoOrganizationInterface $organization
   *   The organization whose fields are being synced.
   * @param FieldData $fieldData
   *   Raw field data.
   */
  public function __construct(
    public readonly CoveoOrganizationInterface $organization,
    public readonly array $fieldData,
  ) {}

}
