<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\coveo_search_api\Plugin\Field\FieldType\FileUriItemAbsolute;

/**
 * Hook implementations for coveo_search_api.
 */
class CoveoSearchApiHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help(string $route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.coveo_search_api':
        return '<p>' . t('Search API integrations for Coveo.') . '</p>';
    }
    return NULL;
  }

  /**
   * Implements hook_field_info_alter().
   */
  #[Hook('field_info_alter')]
  public function fieldInfoAlter(array &$info): void {
    if (isset($info['file_uri'])) {
      // @todo this should be handled in core so we don't conflict with or break
      //   anything by hacking core like this.
      // @see https://www.drupal.org/project/drupal/issues/3504927#comment-15976957
      $info['file_uri']['class'] = FileUriItemAbsolute::class;
    }
  }

}
