<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\coveo_search_api\Plugin\search_api\backend\SearchApiCoveoBackend;
use Drupal\search_api\IndexInterface;

/**
 * Hook implementations for Coveo module.
 *
 * Implements SearchApi entity hooks.
 */
class SearchApiIndexHooks {

  /**
   * Implements hook_search_api_index_presave().
   */
  #[Hook('search_api_index_presave')]
  public function presave(IndexInterface $index): void {
    $server = $index->getServerInstance();
    if ($server?->getBackendId() === 'coveo') {
      $backend = $server->getBackend();
      assert($backend instanceof SearchApiCoveoBackend);
      $organization = $backend->getOrganization();
      if ($organization && !$organization->isReadOnly() && $organization->autoSync()) {
        $organization->sync();
      }
    }
  }

}
