<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;
use Drupal\coveo_search_api\ComputedFileUriAbsolute;
use Drupal\file\Plugin\Field\FieldType\FileUriItem;

/**
 * Hack core FileUri field type to support absolute urls.
 */
class FileUriItemAbsolute extends FileUriItem {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);
    $properties['url_absolute'] = DataDefinition::create('string')
      ->setLabel(t('Absolute file URL'))
      ->setComputed(TRUE)
      ->setInternal(FALSE)
      ->setClass(ComputedFileUriAbsolute::class);
    return $properties;
  }

}
