<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Plugin\search_api\data_type;

use Drupal\file\Entity\File;
use Drupal\search_api\DataType\DataTypePluginBase;

/**
 * Provides a boolean data type.
 *
 * @SearchApiDataType(
 *   id = "coveo_file",
 *   label = @Translation("Coveo File"),
 *   description = @Translation("Coveo file type."),
 *   default = "true"
 * )
 */
class FileDataType extends DataTypePluginBase {

  /**
   * {@inheritDoc}
   */
  public function getValue($value) {
    assert($value instanceof File);
    // @todo be smarter?
    return $value->getFileUri();
  }

}
