<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api\Plugin\search_api\processor;

use Drupal\search_api\Plugin\search_api\data_type\value\TextValue;
use Drupal\search_api\Plugin\search_api\processor\AddHierarchy;

/**
 * Provides a custom full text data type.
 *
 * @SearchApiProcessor(
 *   id = "coveo_hierarchy",
 *   label = @Translation("Coveo Dynamic Hierarchy"),
 *   description = @Translation("Converts a taxonomy with depth into coveo's DynamicHierarchicalFacet format that can be used in their UI components."),
 *   stages = {
 *      "preprocess_index" = -45
 *   },
 * )
 */
class CoveoDynamicHierarchy extends AddHierarchy {

  /**
   * {@inheritDoc}
   */
  public function preprocessIndexItems(array $items): void {
    /*
     * @see https://docs.coveo.com/en/2667/javascript-search-framework/use-hierarchical-facets
     */

    // Call the parent method and let it figure out the hierarchy.
    parent::preprocessIndexItems($items);

    // Parent method has populated all the parents, but it's not in a format
    // Coveo can use yet because it will just be random numbers. We need to
    // convert it to names separated by "|" and then maybe combine them
    // with ";".
    foreach ($items as $item) {
      foreach ($this->configuration['fields'] as $field_id => $property_specifier) {
        $field = $item->getField($field_id);
        if (!$field) {
          continue;
        }
        // @todo convert tree into Coveo format.
        if ($property_specifier == 'taxonomy_term-parent') {
          $entity_storage = $this->getEntityTypeManager()
            ->getStorage('taxonomy_term');
          foreach ($field->getValues() as $entity_id) {
            if ($entity_id instanceof TextValue) {
              $entity_id = $entity_id->getOriginalText();
            }
            if (is_scalar($entity_id)) {
              /** @var \Drupal\taxonomy\TermStorageInterface $entity_storage */
              $path = [];
              foreach ($entity_storage->loadAllParents($entity_id) as $term) {
                $path[] = $term->getName();
              }
              // $path[] = $entity_id;
              $values = $field->getValues();
              $values[array_search($entity_id, $values)] = implode('|', array_reverse($path));
              $field->setValues($values);
            }
          }
          // Try and get things in the order Coveo expects.
          $field->setValues(array_reverse($field->getValues()));
        }
        else {
          // @todo something?
        }
      }

      // @todo Do multiple values get combined here or when pushing?
    }
  }

}
