<?php

declare(strict_types=1);

namespace Drupal\coveo_search_api;

use Drupal\search_api\Event\MappingFieldTypesEvent;
use Drupal\search_api\Event\SearchApiEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Search subscriber to hack data type into field mapping.
 */
class SearchApiSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritDoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      SearchApiEvents::MAPPING_FIELD_TYPES => 'mapFields',
    ];
  }

  /**
   * Map Coveo SearchAPI file properties to our data type.
   *
   * @param \Drupal\search_api\Event\MappingFieldTypesEvent $event
   *   Search API Field mapping event.
   */
  public function mapFields(MappingFieldTypesEvent $event): void {
    // Gross...
    $event->getFieldTypeMapping()['coveo_file'] = 'coveo_file';
  }

}
