<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Declare a Coveo security provider plugin.
 *
 * @Annotation
 */
class CoveoCustomSecurityProvider extends Plugin {

  /**
   * The plugin ID.
   */
  public string $id;

  /**
   * Base name used to identify this plugin in Coveo.
   */
  public string $baseName;

  /**
   * The human-readable title of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $title;

  /**
   * The description of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $description;

}
