<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Attribute;

use Drupal\Component\Plugin\Attribute\AttributeInterface;
use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Declare a Coveo token generator plugin.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class CoveoCustomSecurityProvider extends Plugin implements AttributeInterface {

  /**
   * Construct a Coveo token generator plugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param string $baseName
   *   Base name used to identify this plugin in Coveo.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $title
   *   The human-readable title of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The description of the plugin.
   */
  public function __construct(
    string $id,
    public string $baseName,
    public readonly ?TranslatableMarkup $title = NULL,
    public readonly ?TranslatableMarkup $description = NULL,
  ) {
    parent::__construct($id);
  }

}
