<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\search_api\IndexInterface;

/**
 * Event that allows altering of identities before being sent to coveo.
 */
class CoveoIdentitiesAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \NecLimDul\Coveo\PushApi\Model\IdentityBody[] $identities
   *   Identities to be altered.
   * @param \Drupal\search_api\Item\ItemInterface[] $items
   *   An array of items to be indexed, keyed by their item IDs.
   * @param \Drupal\search_api\IndexInterface $index
   *   The index the documents will be pushed to.
   */
  public function __construct(public array $identities, public readonly array $items, public readonly IndexInterface $index) {}

}
