<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\coveo_secured_search\Entity\CoveoCustomSecurityProvider;
use NecLimDul\Coveo\SecurityCache\Model\SecurityProviderModel;

/**
 * Event that allows altering of security providers before being sent to Coveo.
 */
class CoveoSecurityProviderAlter extends Event {

  /**
   * Constructs the object.
   *
   * @param \Drupal\coveo_secured_search\Entity\CoveoCustomSecurityProvider $securityProvider
   *   Security provider plugin being updated.
   * @param \NecLimDul\Coveo\SecurityCache\Model\SecurityProviderModel $securityProviderModel
   *   Security model about to created or updated.
   */
  public function __construct(
    public readonly CoveoCustomSecurityProvider $securityProvider,
    public readonly SecurityProviderModel $securityProviderModel,
  ) {}

}
