<?php

declare(strict_types=1);

namespace Drupal\coveo_secured_search\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Hook implementations for coveo_secured_search.
 */
class CoveoSecuredSearchHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) {
    switch ($route_name) {
      case 'help.page.coveo_secured_search':
        return 'Secured search through ';

      case 'entity.coveo_custom_security_provider.collection':
        return '<p>' . t('Custom providers provide additional custom methods for identifying users to search components. For example, identifying only be a Drupal user ID.') . '</p>';
    }
  }

}
